<?php

namespace App\Http\Controllers;

use App\Models\Records;
use App\Models\User;
use App\Models\UserPermation;
use Illuminate\Http\Request;

class RecordsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (request()->ajax()) {
        $userpers=UserPermation::where('user_id',auth()->user()->id)->get();
        $records=null;

        foreach ($userpers as $key=>$userper){
            $arr=[$userper->numbersfrom,$userper->numbersto];
            if($key==0){
                if ($userper->numbersto != null) {


                    $records = Records::whereBetween('src',$arr)
                        ->orWhereBetween('dst',$arr);

                }else{
                    $records = Records::where('src',$userper->numbersfrom)
                        ->orWhereBetween('dst',$userper->numbersfrom);
                }
            }else {
                if ($userper->numbersto != null) {
                    $records = $records->whereBetween('src',$arr)
                        ->orWhereBetween('dst',$arr);

                }else{
                    $records = $records->where('src',$userper->numbersfrom)
                        ->orWhereBetween('dst',$userper->numbersfrom);
                }
            }
        }



        if($records==null){
            $records=Records::where('id',-1)->get();
        }else{
            $records=$records->get();
        }


            return datatables()->of($records)
                ->editColumn('calltime', function (Records $id) {
                    return $id->calldate;
                })->editColumn('src', function (Records $id) {
                    return str_pad($id->src, 3, '0', STR_PAD_LEFT);
                })->editColumn('dst', function (Records $id) {
                    return str_pad($id->src, 3, '0', STR_PAD_LEFT);
                })->editColumn('duration', function (Records $id) {
                    return $id->duration;
                })->editColumn('filepath', function (Records $id) {
                    return view('cpanel.records.actions', compact('id'));
                })
                ->make(true);
        }
        $title = "__('User Records')";
        return view('cpanel.records.index', ['title' => $title,'user'=>auth()->user()]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Records  $records
     * @return \Illuminate\Http\Response
     */
    public function show(Records $records)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Records  $records
     * @return \Illuminate\Http\Response
     */
    public function edit(Records $records)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Records  $records
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Records $records)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Records  $records
     * @return \Illuminate\Http\Response
     */
    public function destroy(Records $records)
    {
        //
    }
}
