<?php

namespace App\Http\Controllers;

use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Rules\MatchOldPassword;


class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (request()->ajax()) {
            $users = User::where('type_user','0')->get();
            return datatables()->of($users)
                ->editColumn('name', function ($id) {
                    return view('cpanel.users.actions', compact('id'));
                })->editColumn('permations', function ($id) {
                    return '';
                })
                ->editColumn('created_at', function ($users) {
                    if(app()->getLocale() == 'ar'){
                        return ArabicDate($users->created_at);
                    }else{
                        return $users->created_at;
                    }
                })
                ->make(true);
        }
        return view('cpanel.users.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cpanel.users.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = new User();
        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/users/images/'), $imageName);
            $user->image = 'uploads/users/images/' . $imageName;
        } else {
            $user->image = 'uploads/users/image_hoder.jpg';
        }
        $user->name = $request->name;
        $user->email = $request->email;
        $user->locale = $request->lang;
        $user->type_user = '0';
        $user->state = '1';
        $user->password = Hash::make($request->password);
        $user->save();

        return redirect(route(app()->getLocale().'.users.index'))->with('success.add', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $users = User::findOrFail($id);
        return view('cpanel.users.edit', compact('users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UserRequest $request, $id)
    {
        $user = User::findOrFail($id);
        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/users/images/'), $imageName);
            $user->image = 'uploads/users/images/' . $imageName;
        }


        $user->name = $request->name;
        $user->email = $request->email;
        $user->state = '1';

        if (isset($request->password)) {
            $user->password = Hash::make($request->password);
        }
        $user->type_user = '0';
        $user->locale = $request->lang;
        $user->gender = $request->gender;
        $user->updated_by = Auth::id();
        $user->update();
        return redirect(route(app()->getLocale().'.users.index'))->with('success.update', true);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->update(['deleted_by' => Auth::id()]);
        $user->delete();
        return Response()->json($user);
    }

    public function editProfile()
    {
        $user = User::select('*')->where('id',Auth::id())->first();
        return view('cpanel.users.profile',['user' => $user,]);
    }

    public function updateProfile(UserRequest $request)
    {

        $user = User::where('id',Auth::id())->first();

        if (isset($request->current_password) || isset($request->new_password) || isset($request->new_confirm_password)) {
            $request->validate([
                'name' => 'required',
                'current_password' => ['required_with:new_password', new MatchOldPassword],
                'new_password' => ['required_with:current_password', 'required_with:new_confirm_password', ],
                'new_confirm_password' => ['same:new_password', 'required_with:new_password',],
            ], [
                'required' =>__("The Field is required"),
                'current_password.required_with' => __('The current password must be entered'),
                'new_password.required_with' =>  __('The new password must be entered'),
                'new_confirm_password.required_with' => __('The new password must be confirmed'),
                'new_confirm_password.same' => __('Password does not match'),
            ]);
            $user->password = Hash::make($request->new_password);
        }

        if ($request->hasFile('image')) {
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/users/images/'), $imageName);
            $user->image = 'uploads/users/images/' . $imageName;
        }
        $user->name = $request->name;
        $user->email = $request->email;
        $user->locale = $request->lang;

//        $user->updated_by = Auth::id();
        $user->update();
        return back()->with('success.update', true);
    }

    public function change_state($id)
    {
        $user = User::findOrFail($id);

        if ($user->getRawOriginal('state') == '0') {
            $user->update(['state' => '1','updated_by' => Auth::id()]);
        } else {
            $user->update(['state' => '0','updated_by' => Auth::id()]);
        }
    }
}
