<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\UserPermation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserPermationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(User $user)
    {
        if (request()->ajax()) {
            $user_permission = UserPermation::where('user_id',$user->id)->get();
            return datatables()->of($user_permission)
                ->editColumn('permission', function (UserPermation $id) {
                    if( $id->numbersto!=null)
                    return $id->numbersfrom . " _ " . $id->numbersto;
                    else
                        return $id->numbersfrom;
                })->editColumn('actions', function (UserPermation $id) {
                    return view('cpanel.permission.actions', compact('id'));

                })
                ->make(true);
        }
        $title = "__('User Permissions')";
        return view('cpanel.permission.index', ['title' => $title,'user'=>$user]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $id = $request->id;
        $car_size = UserPermation::updateOrCreate(
            ['id' => $id],
            [
                'numbersfrom' => $request->from,
                'numbersto' => $request->to,
                'user_id' => $request->user_id,
                'created_by' => Auth::id(),
            ]
        );

        return Response()->json($car_size);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\UserPermation $userPermation
     * @return \Illuminate\Http\Response
     */
    public function show(UserPermation $userPermation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\UserPermation $userPermation
     * @return \Illuminate\Http\Response
     */
    public function edit(UserPermation $userPermation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Models\UserPermation $userPermation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UserPermation $userPermation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\UserPermation $userPermation
     * @return \Illuminate\Http\Response
     */
    public function destroy(UserPermation $permission)
    {
        $permission->delete();
        return Response()->json($permission);
    }
}
