<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('الاسم');
            $table->string('image')->nullable()->comment('الصورة الشخصية');
            $table->string('email')->unique()->comment('الاميل');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            ////
            $table->timestamp('verification_code')->nullable();
            $table->enum('state', [0, 1])->default(1)->comment('1 = فعال');
            $table->enum('type_user', [0, 1])->default(1)->comment('1 = أدمن');
            ////
            $table->string('phone')->nullable()->unique()->comment('رقم الهاتف');
            $table->string('locale')->nullable()->default('ar')->comment('ar');

            ////
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
        DB::connection('mysql')->table('users')->insert(
            [
                'name' => 'admin',
                'email' => 'admin@admin.com',
                'password' => Hash::make('123456789'),
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('users');
    }
}
