@extends('cpanel.app')
@section('title', __('User Permissions'))
@section('css')
    <style>
        .error{
            color: #ef5350;
        }
    </style>
    @stop
@section('content')
    <div class="column page">
        <div class="header">
            <section class="title">
                <h3>{{__('User Permissions')}}</h3>

                <div class="controls">
                    <nav class="breadcrumb default">
                        <a class="breadcrumb-item breadcrumb-icon" href="{{url('/')}}">
                            <span class="la la-home icon"></span>
                        </a>
                        <span class="breadcrumb-item active" href="#">{{__('User Permissions')}}</span>
                    </nav>
                </div>
            </section>
        </div>

        <div class="content">
            <div class="body content-nav">
                <div class="nav-body">
                    <div class="nav-body-wrapper">
                        <div class="container-fluid">
                            <a href="javascript:void(0)" class="btn btn-primary" id="create">{{__('New User Permission')}}</a>
                            <br><br>
                            <table id="datatable" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th>{{__('#')}}</th>
                                    <th>{{__('Permission')}}</th>
                                    <th>{{__('Actions')}}</th>
                                </tr>
                                </thead>
                            </table>
                        </div>

                        @include('cpanel.permission.addEdit')

                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
@section('datatable')
    @parent
@section('data')
    ajax: {
    url: "{{route(app()->getLocale().'.permission.index',['user' => $user->id])}}",
    type: 'GET'
    },
    columns: [
    { data: 'id', name: 'id' },
    { data: 'permission', name: 'permission',class:'post_item'},
    { data: 'actions', name: 'actions'},
    ]
@endsection
@endsection
@section('js')
    @include('cpanel.permission.operations')
    @include('cpanel.include._success')
    @include('cpanel.include._script')
@stop

