@extends('cpanel.app')
@section('title', __('User Permissions'))
@section('css')
    <style>
        .error{
            color: #ef5350;
        }
    </style>
    @stop
@section('content')
    <div class="column page">
        <div class="header">
            <section class="title">
                <h3>{{__('User Permissions')}}</h3>

                <div class="controls">
                    <nav class="breadcrumb default">
                        <a class="breadcrumb-item breadcrumb-icon" href="{{url('/')}}">
                            <span class="la la-home icon"></span>
                        </a>
                        <span class="breadcrumb-item active" href="#">{{__('User Records')}}</span>
                    </nav>
                </div>
            </section>
        </div>

        <div class="content">
            <div class="body content-nav">
                <div class="nav-body">
                    <div class="nav-body-wrapper">
                        <div class="container-fluid">
                            <table id="datatable" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th>{{__('#')}}</th>
                                    <th>{{__('Call Date')}}</th>
                                    <th>{{__('Src')}}</th>
                                    <th>{{__('Dest')}}</th>
                                    <th>{{__('Duration')}}</th>
                                    <th>{{__('File')}}</th>
                                </tr>
                                </thead>
                            </table>
                        </div>



                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
@section('datatable')
    @parent
@section('data')
    ajax: {
    url: "{{route(app()->getLocale().'.records.index')}}",
    type: 'GET'
    },
    columns: [
    { data: 'id', name: 'id' },
    { data: 'calltime', name: 'calltime'},
    { data: 'src', name: 'src'},
    { data: 'dst', name: 'dst'},
    { data: 'duration', name: 'duration'},
    { data: 'filepath', name: 'filepath'},
    ]
@endsection
@endsection
@section('js')
    @include('cpanel.include._success')
    @include('cpanel.include._script')
@stop

