@csrf
<div class="row">
    <div class="col-lg-8">
        <div class="card panel">
            <div class="card-block">
                <div class="form-group col-lg-12">
                    <label>{{__('User Name')}}</label>
                    <input type="text" class="form-control" data-validation="required"
                           data-validation-error-msg-required="{{__('* This field is required.')}}"
                           name="name" value="{{ old('name', $users->name) }}">
                    @error('name')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group col-lg-6">
                    <label> {{__('Email')}}</label>
                    <input type="email" class="form-control" data-validation="email required"
                           data-validation-error-msg="{{__('* Please enter a valid email.')}}"
                           data-validation-error-msg-required="{{__('* This field is required.')}}"
                           name="email" value="{{ old('email', $users->email) }}">
                    @error('email')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group col-lg-6">
                    <label> {{__('Phone')}}</label>
                    <input id="phone" type="text" class="form-control" data-validation="number"
                           data-validation-error-msg="{{__('* Please enter a valid phone.')}}"
                           name="phone" value="{{ old('phone', $users->phone) }}">
                    @error('phone')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group col-lg-6">
                    <label for="password">{{__('Password')}}</label>
                    <input id="password" type="password" data-validation="required"
                           data-validation-error-msg-required="{{__('* This field is required.')}}"
                           class="form-control @error('password') is-invalid @enderror"
                           name="password" autocomplete="new-password">
                    @error('password')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-group  col-lg-6">
                    <label for="password-confirm">{{__('Password Confirm')}}</label>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                           data-validation="required"
                           data-validation-error-msg-required="{{__('* This field is required.')}}"
                           autocomplete="new-password">
                </div>


                <script>
                    var openFile = function (file) {
                        var input = file.target;

                        var reader = new FileReader();
                        reader.onload = function () {
                            var dataURL = reader.result;
                            var output = document.getElementById('image-select');
                            output.src = dataURL;
                        };
                        reader.readAsDataURL(input.files[0]);
                    };
                </script>
                <div class="form-group col-lg-4">
                    <div><label>{{__('The language')}}/</label></div>
                    <label class="custom-control custom-radio">
                        <input type="radio" class="custom-control-input" value="en" data-validation="required"
                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                               name="lang" @if(!$users->locale) checked @endif @if($users->locale=='en') checked @endif>
                        <span class="custom-control-indicator"></span>
                        <span class="custom-control-description">{{__('English')}}</span>
                    </label>
                    <label class="custom-control custom-radio">
                        <input id="manger" type="radio" class="custom-control-input" data-validation="required"
                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                               name="lang" value="ar" @if($users->locale=='ar') checked @endif>
                        <span class="custom-control-indicator"></span>
                        <span class="custom-control-description">{{__('Arabic')}}</span>
                    </label>
                </div>


                <div class="form-group col-lg-12">
                    <button type="submit" value="upload" name="fileSubmit"
                            class="btn btn-primary">{{__('Save')}}
                    </button>
                </div>

            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div id="widget-attachments-images-only" class="card panel widget-attachments">
            <div class="card-block">
                <div
                    class="form-group float-right mt-auto mb-auto @if(App::getLocale() == 'ar') ml-3 @else mr-3 @endif">
                    <h5 class="header">{{__('User image')}}</h5>
                    <button class="btn btn-primary btn-file">
                        <span class="la la-cloud-upload icon"></span>
                        <p class="text"
                           style="max-width: 67px;overflow: hidden;height: 20px;">{{__('Choose Image')}}</p>
                        <input type="file" class="img_found"
                               onchange="openFile(event,'image-select')"
                               name="image" id="file_image"
                               data-validation="mime size dimension"
                               data-validation-allowing="jpg, png, gif"
                               data-validation-max-size="9048kb"
                               data-validation-dimension="min100x100">
                    </button>
                    @error('image')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div style="overflow: hidden;height:153px">
                    <img
                        src="@if($users->image){{asset('')}}thumb.php?src={{$users->image}}&size=230x153 @else {{asset('thumb.php?src=dashboard/assets/img/avatars/placeholders/ava-256.png&size=230x153')}}@endif"
                        id="image-select" alt=" ">
                </div>

            </div>


        </div>
    </div>
</div>
