@extends('cpanel.app')
@section('title', __('Add User'))
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/assets/styles/widgets/upload.min.css')}}">
    <style>
        .widget-attachments .card-block{
            display: flex;
        }
    </style>
@stop
@section('content')
    <div class="column page">
        <div class="header">
            <section class="title">
                <h3>{{__('Add User')}}</h3>

                <div class="controls">
                    <nav class="breadcrumb default">
                        <a class="breadcrumb-item breadcrumb-icon" href="{{url('/')}}">
                            <span class="la la-home icon"></span>
                        </a>
                        <span class="breadcrumb-item active" href="#">{{__('Add User')}}</span>
                    </nav>
                </div>

            </section>
        </div>
        <div class="content">
            <div class="body content-nav">

                <div class="nav-body">
                    <div class="nav-body-wrapper">
                        <div class="container-fluid">
                            <form action="{{route(app()->getLocale().'.users.store')}}" method="post" enctype="multipart/form-data">
                                @include('cpanel.users._form', ['users' => new App\Models\User(),])
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    @include('cpanel.include._script')
@stop
