@extends('cpanel.app')
@section('title', __('Users'))
@section('content')
    <div class="column page">
        <div class="header">
            <section class="title">
                <h3>{{__('Users')}}</h3>

                <div class="controls">
                    <nav class="breadcrumb default">
                        <a class="breadcrumb-item breadcrumb-icon" href="{{url('/')}}">
                            <span class="la la-home icon"></span>
                        </a>
                        <span class="breadcrumb-item active" href="#">{{__('Users Menu')}}</span>
                    </nav>
                </div>
            </section>
        </div>

        <div class="content">
            <div class="body content-nav">
                <div class="nav-body">
                    <div class="nav-body-wrapper">

                        <div class="container-fluid">

                            <table id="datatable" class="table table-striped table-bordered" cellspacing="0"
                                   width="100%">
                                <thead>
                                <tr>
                                    <th class="no_sort">{{__('No.')}}</th>
                                    <th>{{__('User Name')}}</th>
                                    <th>{{__('Email')}}</th>
                                    <th>{{__('Permations')}}</th>
                                    <th>{{__('Created_at')}}</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
@section('datatable')
    @parent
@section('data')
    ajax: {
    url: '{{route(app()->getLocale() .'.users.index')}}',
    type: 'GET'
    },
    columns: [
    {data: 'id', name: 'id'},
    { data: 'name', name: 'name', class:'post_item' },
    { data: 'email', name: 'email' },
    { data: 'permations', name: 'permations' },
    { data: 'created_at', name: 'created_at' },

    ]
@endsection
@endsection
@section('js')
    @include('cpanel.users.operations')
    @include('cpanel.include._success')
@stop

