<script>
    var SITEURL = '{{URL::to('')}}/{{app()->getLocale()}}';
    /* When click deleted */
    function deleted_(id) {

        swal({
                    title: "{{__('Are you sure?')}}",
                    text: "{{__('Deleted will now be done!')}}",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: 'btn-warning',
                    confirmButtonText: '{{__('Yes, delete')}}',
                    closeOnConfirm: false,
                    closeOnCancel: true,
                    cancelButtonText: "{{__('Not Now')}}"
                },
                function() {
                    $.ajax({
                        type: "DELETE",
                        url: SITEURL + "/users/"+id,
                        success: function (data) {
                            swal({
                                title: "{{__('Deleted was successful!')}}",
                                text: "{{__('Sent to trash!')}}",
                                type: "success",
                                confirmButtonClass: 'btn-success',
                                confirmButtonText: "{{__('Done')}} "
                            });
                            var oTable = $('#datatable').dataTable();
                            oTable.fnDraw(false);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                            swal({
                                title: "{{__('Error!')}}",
                                text: "{{__('Not deleted!')}}",
                                type: "error",
                                confirmButtonClass: 'btn-danger',
                                confirmButtonText: "{{__('OK')}} "
                            });
                        }
                    });
                });
    }

</script>
