@extends('cpanel.app')
@section('title', __('Edit Profile'))
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/assets/styles/widgets/upload.min.css')}}">
    <style>
        .widget-attachments .card-block {
            display: flex;
        }
    </style>
@stop

@section('content')
    <div class="column page">
        <div class="header">
            <section class="title">
                <h3>{{__('Edit Profile')}}</h3>

                <div class="controls">
                    <nav class="breadcrumb default">
                        <a class="breadcrumb-item breadcrumb-icon" href="{{url('/')}}">
                            <span class="la la-home icon"></span>
                        </a>
                        <span class="breadcrumb-item active" href="#">{{__('Edit Profile')}}</span>
                    </nav>
                </div>

            </section>
        </div>
        <div class="content">
            <div class="body content-nav">

                <div class="nav-body">
                    <div class="nav-body-wrapper">
                        <div class="container-fluid">
                            <form action="{{route(app()->getLocale().'.profile.update')}}" method="post"
                                  enctype="multipart/form-data">
                                @method('PUT')
                                @csrf
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="card panel">
                                            <div class="card-block">
                                                <div class="row">
                                                    <div class="form-group col-lg-12">
                                                        <label>{{__('User Name')}}</label>
                                                        <input type="text" class="form-control"
                                                               name="name" value="{{ $user->name }}"
                                                               data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}">
                                                        @error('name')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-lg-6">
                                                        <label> {{__('Email')}}</label>
                                                        <input type="email" class="form-control"
                                                               data-validation="email required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               data-validation-error-msg="{{__('* Please enter a valid email.')}}"
                                                               name="email" value="{{ $user->email }}">
                                                        @error('email')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>

                                                    <div class="form-group col-lg-6">
                                                        <label> {{__('Phone')}}</label>
                                                        <input type="text" class="form-control" data-validation="number"
                                                               data-validation-error-msg="{{__('* Please enter a valid phone.')}}"
                                                               name="phone" value="{{ $user->phone }}">
                                                        @error('phone')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="row mt-0">
                                                    <div class="form-group col-lg-4">
                                                        <label for="password">{{__('Current Password')}}</label>
                                                        <input id="password" type="password" data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               class="form-control @error('password') is-invalid @enderror"
                                                               name="current_password" autocomplete="current-password"
                                                        >

                                                        @error('current_password')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <label for="password"
                                                        >{{__('New Password')}}</label>
                                                        <input id="password" type="password" data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               class="form-control @error('password') is-invalid @enderror"
                                                               name="new_password" autocomplete="current-password">

                                                        @error('new_password')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-lg-4">
                                                        <label for="password">{{__('Password Confirm')}}</label>
                                                        <input id="password" type="password" data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               class="form-control @error('password') is-invalid @enderror"
                                                               name="new_confirm_password"
                                                               autocomplete="current-password">

                                                        @error('new_confirm_password')
                                                        <div class="alert alert-danger">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div><label>{{__('The language')}}/</label></div>
                                                    <label class="custom-control custom-radio">
                                                        <input type="radio" class="custom-control-input" value="en" data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               name="lang" @if($user->locale=='en') checked @endif>
                                                        <span class="custom-control-indicator"></span>
                                                        <span
                                                            class="custom-control-description">{{__('English')}}</span>
                                                    </label>
                                                    <label class="custom-control custom-radio">
                                                        <input id="manger" type="radio" class="custom-control-input" data-validation="required"
                                                               data-validation-error-msg-required="{{__('* This field is required.')}}"
                                                               name="lang" value="ar"
                                                               @if($user->locale=='ar') checked @endif>
                                                        <span class="custom-control-indicator"></span>
                                                        <span class="custom-control-description">{{__('Arabic')}}</span>
                                                    </label>
                                                </div>
                                                <script>
                                                    var openFile = function (file) {
                                                        var input = file.target;

                                                        var reader = new FileReader();
                                                        reader.onload = function () {
                                                            var dataURL = reader.result;
                                                            var output = document.getElementById('image-select');
                                                            output.src = dataURL;
                                                        };
                                                        reader.readAsDataURL(input.files[0]);
                                                    };
                                                </script>

                                                <div class="form-group">
                                                    <button type="submit" value="upload" name="fileSubmit"
                                                            class="btn btn-primary">{{__('Save')}}
                                                    </button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div id="widget-attachments-images-only" class="card panel widget-attachments">
                                            <div class="card-block">
                                                <div
                                                    class="form-group float-right mt-auto mb-auto @if(App::getLocale() == 'ar') ml-3 @else mr-3 @endif">
                                                    <h5 class="header">{{__('My image')}}</h5>
                                                    <button class="btn btn-primary btn-file">
                                                        <span class="la la-cloud-upload icon"></span>
                                                        <p class="text"
                                                           style="max-width: 67px;overflow: hidden;height: 20px;">{{__('Choose Image')}}</p>
                                                        <input type="file" class="img_found"
                                                               onchange="openFile(event,'image-select')"
                                                               name="image" id="file_image"
                                                               data-validation="mime size dimension"
                                                               data-validation-allowing="jpg, png, gif"
                                                               data-validation-max-size="9048kb"
                                                               data-validation-dimension="min100x100">
                                                    </button>
                                                    @error('image')
                                                    <div class="alert alert-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                                <div style="overflow: hidden;height:153px">
                                                    <img
                                                        src="@if($user->image){{asset('')}}thumb.php?src={{$user->image}}&size=230x153 @else {{asset('thumb.php?src=dashboard/assets/img/avatars/placeholders/ava-256.png&size=230x153')}}@endif"
                                                        id="image-select" alt=" ">
                                                </div>

                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    @include('cpanel.include._script')
    @include('cpanel.include._success')
@stop
