<?php

use Getsupercode\Localizater\Facades\Localizater;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes(['register' => false]);

Localizater::group(['middleware' => 'auth'], function () {

    Route::get('/{route?}', [App\Http\Controllers\HomeController::class, 'index'])
        ->where('route', '(home|index)')->name('home');




    /**
     * all Route in User
     */
    Route::resource('users', \App\Http\Controllers\UserController::class);
    Route::get('/profile', [App\Http\Controllers\UserController::class, 'editProfile'])->name('profile.edit');
    Route::put('/profile', [App\Http\Controllers\UserController::class, 'updateProfile'])->name('profile.update');
    Route::get('change_state/{id}', [App\Http\Controllers\UserController::class, 'change_state'])->name('change_state');

    /**
     * all Route in Car Size
     */
    Route::get('permission/{user}', [\App\Http\Controllers\UserPermationController::class,'index'])->name('permission.index');
    Route::get('records', [\App\Http\Controllers\RecordsController::class,'index'])->name('records.index');
    Route::post('permission/store', [\App\Http\Controllers\UserPermationController::class,'store'])->name('permission.store');
    Route::delete('permission/{permission}', [\App\Http\Controllers\UserPermationController::class,'destroy'])->name('permission.destroy');


});
