<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(locale_dir()); ?>">

<!-- BEGIN HEAD -->
<head>
    <meta charset="UTF-8">
    <?php if(App::getLocale() == 'en'): ?>
        <title><?php echo e(config('app.name')); ?> - <?php echo $__env->yieldContent('title'); ?></title>
    <?php elseif(App::getLocale() == 'ar'): ?>
        <title> <?php echo $__env->yieldContent('title'); ?></title>
    <?php endif; ?>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('assets/assets/shortcut-icon.png')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/bootstrap/css/bootstrap.min.css')); ?>">
    <?php if(App::getLocale() == 'ar'): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/bootstrap/css/bootstrap-rtl.css')); ?>">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/assets/fonts/line-awesome/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/fonts/open-sans/styles.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/fonts/dinnext/styles.css')); ?>">
    <?php if(App::getLocale() == 'en'): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/boraq/style-en.css')); ?>">
    <?php elseif(App::getLocale() == 'ar'): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/boraq/style.css')); ?>">
    <?php endif; ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/tether/css/tether.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/jscrollpane/jquery.jscrollpane.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/flag-icon-css/css/flag-icon.min.css')); ?>">
    <?php if(App::getLocale() == 'en'): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/common.css')); ?>">
    <?php elseif(App::getLocale() == 'ar'): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/common.min.css')); ?>">
    <?php endif; ?>
<!-- END GLOBAL MANDATORY STYLES -->

    <!-- BEGIN THEME STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/themes/primary.min.css')); ?>">
    <link class="sidebar-dark-style" rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/assets/styles/themes/sidebar-black.min.css')); ?>">
    <!-- END THEME STYLES -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/fonts/kosmo/styles.css')); ?>">
<!--<link rel="stylesheet" href="<?php echo e(asset('assets/css/fancybox.min.css')); ?>">-->

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/izi-modal/css/iziModal.min.css')); ?>">
    <!-- Original -->
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/assets/styles/libs/izi-modal/izi-modal.min.css')); ?>">
    <!-- Original -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/c3js/c3.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/noty/noty.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/widgets/panels.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/assets/styles/libs/touchspin/touchspin.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/sweetalert/sweetalert.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/libs/sweetalert/sweetalert.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/libs/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/styles/libs/select2/select2.min.css')); ?>">
    <script src="<?php echo e(asset('dashboard/libs/jquery/jquery.min.js')); ?>"></script>

    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/libs/datatables-net/media/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/css/buttons.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
          href="<?php echo e(asset('dashboard/assets/styles/libs/datatables-net/datatables.min.css')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>

<!--<link rel="stylesheet" type="text/css" href="<?php echo e(asset('dashboard/assets/scripts/jquery.validate.js')); ?>">-->
    <?php if(App::getLocale() == 'ar'): ?>
        <style>
            table.dataTable thead .sorting:before, table.dataTable thead .sorting_asc:before, table.dataTable thead .sorting_desc:before, table.dataTable thead .sorting_asc_disabled:before, table.dataTable thead .sorting_desc_disabled:before {
                left: 1em !important;
                right: inherit;
            }

            table.dataTable thead .sorting:after, table.dataTable thead .sorting_asc:after, table.dataTable thead .sorting_desc:after, table.dataTable thead .sorting_asc_disabled:after, table.dataTable thead .sorting_desc_disabled:after {
                left: 0.5em !important;
                right: inherit;
            }

            .custom-control-indicator {
                right: 0 !important;
            }

            .tab-pane .card.panel {
                border-radius: 2px !important;
            }

            .nav.nav-tabs {
                border-right: 3px solid #eff0f1;
            }
        </style>
    <?php endif; ?>
    <style>
        .alert.alert-danger {
            border-color: #fbe0db;
            border: 0;
            padding: 10px 0;
            color: #a94442;
        }

        .select2-container {
            width: 100% !important;
        }

        div.dataTables_wrapper .dataTables_length {
            padding: 20px !important;
        }

        div.dataTables_wrapper .dt-buttons {
            margin-top: 0;
        }
    </style>
    <style>
        .navbar {
            background: #3e3a66 !important;
        }

        .navbar .nav-item.active, .navbar .nav-item.show, .navbar .nav-item:hover {
            background: #f8a82a;
        }

        .navbar .nav-item {
            border-color: #5b5788;
        }

        .navbar > .wrapper > .nav > .navbar-actions > .user {
            border-right: 1px solid #5b5788;
        }

        .navbar .navbar-brand .logo {
            color: #f8a82a;
        }

        .btn-primary {
            background-color: #3e3a66;
            border: solid 1px #3e3a66;
        }

        .btn-primary:hover {
            color: #fff;
            background-color: #f8a82a;
            border-color: #f8a82a;
        }

        .btn-primary:active, .btn-primary:focus {
            color: #fff;
            background-color: #3e3a66;
            border-color: #3e3a66;
        }

        .page-item.active .page-link, .page-item.active .page-link:focus, .page-item.active .page-link:hover {
            color: #fff;
            background-color: #3e3a66;
            border-color: #3e3a66;
        }

        .iziModal .iziModal-header {
            background: #3e3a66;
        }

        body.sidebar-sections > .container .sidebar .wrapper section > .nav .nav-item .nav-link, body.sidebar-sections > .container .sidebar .wrapper section > .nav .nav-item .dropdown-item, body.sidebar-sections .page-container .sidebar .wrapper section > .nav .nav-item .nav-link, body.sidebar-sections .page-container .sidebar .wrapper section > .nav .nav-item .dropdown-item {
            height: 50px;
            min-height: 50px;
        }

        .content-nav > .nav-body {
            background: #f4f4f4;
        }

        /*a, button, label, .form-control {*/
        /*    font-weight: 600 !important;*/
        /*}*/

        .select2-container.select2-container--default .select2-selection--single .select2-selection__rendered {
            font-weight: 600 !important;
        }

        .avatar {
            object-fit: cover;
        }
    </style>
    <?php echo $__env->yieldContent('css'); ?>
</head>
<!-- END HEAD -->

<body class="navbar-fixed sidebar-sections sidebar-position-fixed page-header-fixed theme-primary page-loading">
<!-- remove page-header-fixed to unfix header -->

<!-- BEGIN HEADER -->
<nav class="navbar navbar">
    <!-- BEGIN HEADER INNER -->
    <!-- BEGIN LOGO -->
    <div href="index.html" class="navbar-brand">
        <!-- BEGIN RESPONSIVE SIDEBAR TOGGLER -->
        <a href="#" class="sidebar-toggle"><i class="icon la la-bars" aria-hidden="true"></i></a>
        <a href="#" class="sidebar-mobile-toggle"><i class="icon la la-bars" aria-hidden="true"></i></a>
        <!-- END RESPONSIVE SIDEBAR TOGGLER -->

        <div class="navbar-logo">
            
            <a href="<?php echo e(route(app()->getLocale() .'.home')); ?>" target="_blank" class="logo"><?php echo e(__('Car Wash')); ?></a>


            <!-- END GRID NAVIGATION -->
        </div>
    </div>
    <!-- END LOGO -->

    <!-- BEGIN MENUS -->
    <div class="wrapper">
        <nav class="nav navbar-nav">
            <!-- BEGIN NAVBAR MENU -->
            <div class="navbar-menu">
                <a class="nav-item nav-link" href="<?php echo e(route(app()->getLocale() .'.home')); ?>"><?php echo e(__('Home')); ?></a>

            </div>
            <!-- END NAVBAR MENU -->

            <!-- BEGIN NAVBAR ACTIONS -->
            <div class="navbar-actions">
                <!-- BEGIN NAVBAR USER -->

                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" style="text-transform: uppercase;" data-toggle="dropdown"
                       href="#" role="button" aria-haspopup="true" aria-expanded="false">
                        <?php echo e(app()->getLocale()); ?>

                    </a>

                    <div class="dropdown-menu info" aria-labelledby="Preview">
                        <a class="dropdown-item"
                           href="<?php echo e(locale_route(null, 'en', ['status' => 'active'], true)); ?>"><?php echo e(__('English')); ?></a>
                        <a class="dropdown-item"
                           href="<?php echo e(locale_route(null, 'ar', ['status' => 'active'], true)); ?>"><?php echo e(__('Arabic')); ?></a>

                    </div>
                </div>

                <div class="nav-item dropdown user">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button"
                       aria-haspopup="true" aria-expanded="false">
                        <span class="avatar">
                            <img
                                src="<?php if(Auth::user()->image): ?><?php echo e(asset('')); ?>thumb.php?src=<?php echo e(Auth::user()->image); ?>&size=36x36 <?php else: ?> <?php echo e(asset('thumb.php?src=dashboard/assets/img/avatars/placeholders/l60Hf.png&size=36x36')); ?><?php endif; ?>">
                        </span>
                        <span class="info">
                            <span class="name"> <?php echo e(Auth::user()->name); ?></span>
                            <span
                                class="description"><?php if(Auth::user()->type_user=='0'): ?> <?php echo e(__('Administrator')); ?> <?php else: ?> <?php echo e(__('User')); ?> <?php endif; ?></span>
                        </span>
                    </a>

                    <div
                        class="dropdown-menu <?php if(App::getLocale() == 'en'): ?> dropdown-menu-left <?php else: ?> dropdown-menu-right <?php endif; ?>"
                        aria-labelledby="Preview">
                        <a class="dropdown-item" href="<?php echo e(route(app()->getLocale() .'.profile.edit')); ?>">
                            <span class="la la-wrench icon" aria-hidden="true"></span>
                            <span> <?php echo e(__('Edit Profile')); ?></span>
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                            <span class="la la-sign-out icon" aria-hidden="true"></span>
                            <span> <?php echo e(__('Log out')); ?>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                            </span>
                        </a>
                    </div>
                </div>
                <!-- END NAVBAR USER -->
            </div>
            <!-- END NAVBAR ACTIONS -->
        </nav>

        <!-- BEGIN NAVBAR ACTIONS TOGGLER -->
        <nav class="nav navbar-nav navbar-actions-toggle">
            <a class="nav-item nav-link" href="#">
                <span class="la la-ellipsis-h icon open"></span>
                <span class="la la-close icon close"></span>
            </a>
        </nav>
        <!-- END NAVBAR ACTIONS TOGGLER -->

        <!-- BEGIN NAVBAR MENU TOGGLER -->
        <nav class="nav navbar-nav navbar-menu-toggle">
            <a class="nav-item nav-link" href="#">
                <span class="la la-th icon open"></span>
                <span class="la la-close icon close"></span>
            </a>
        </nav>
        <!-- END NAVBAR MENU TOGGLER -->
    </div>
    <!-- END MENUS -->
    <!-- END HEADER INNER -->
</nav>
<!-- END HEADER -->

<div class="page-container dashboard-tabbed-sidebar-fixed-tabs">

    <!-- BEGIN DEFAULT SIDEBAR -->
    <div class="column sidebar info">
        <div class="wrapper">
            <section>
                
                <ul class="nav nav-pills nav-stacked">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route(app()->getLocale() .'.home')); ?>">
                            <span class="icon la la-home"></span>
                            <span><?php echo e(__('Home')); ?></span>
                        </a>
                    </li>

                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" aria-haspopup="true"
                           aria-expanded="false">
                            <span class="icon la la-users"></span>
                            <span><?php echo e(__('Users')); ?></span>
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" style="border-bottom:1px solid #434950 !important;"
                               href="<?php echo e(route(app()->getLocale() .'.users.create')); ?>"><?php echo e(__('Add User')); ?></a>
                            <a class="dropdown-item" style="border-bottom:1px solid #434950 !important;"
                               href="<?php echo e(route(app()->getLocale() .'.users.index')); ?>"><?php echo e(__('Users Menu')); ?></a>

                        </div>
                    </li>


                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    

                </ul>
            </section>

        </div>
    </div>
    <!-- END DEFAULT SIDEBAR -->


    <?php echo $__env->yieldContent('content'); ?>

</div>

<!--BEGIN brecking modal-->
<!--End brecking modal-->

<!-- BEGIN PAGE LEVEL PLUGINS -->
<script src="<?php echo e(asset('dashboard/libs/responsejs/response.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/loading-overlay/loadingoverlay.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/tether/js/tether.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/bootstrap/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/jscrollpane/jquery.jscrollpane.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/jscrollpane/jquery.mousewheel.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/flexibility/flexibility.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/noty/noty.min.js')); ?>"></script>
<!-- END PAGE LEVEL PLUGINS -->

<!-- BEGIN THEME LAYOUT SCRIPTS -->
<script src="<?php echo e(asset('dashboard/assets/scripts/common.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/sweetalert/sweetalert.min.js')); ?>"></script>
<!-- END THEME LAYOUT SCRIPTS -->
<!--<script src="<?php echo e(asset('assets/js/fancybox.min.js')); ?>" type="text/javascript"></script>-->
<script src="<?php echo e(asset('dashboard/libs/c3js/c3.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/noty/noty.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/izi-modal/js/iziModal.min.js')); ?>"></script>

<script src="<?php echo e(asset('dashboard/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/select2/js/select2.min.js')); ?>"></script>
<script>
    $('#izi-modal-danger').iziModal();
    $('.izi-modal-trigger').on('click', function (e) {
        $($(this).data('target')).iziModal('open');
    });
    (function ($) {
        $(document).ready(function () {
            $('#touchspin-vertical-buttons').TouchSpin({
                verticalbuttons: true,
                verticalupclass: 'la la-plus',
                verticaldownclass: 'la la-minus',
                min: 1,
                max: 30
            });

            $('#touchspin-button').TouchSpin({
                postfix: "button",
                postfix_extraclass: "btn btn-default"

            });
        });
    })(jQuery);
</script>
<script src="<?php echo e(asset('dashboard/libs/datatables-net/media/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/datatables-net/media/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/jszip/jszip.min.js')); ?>"></script>
<!--<script src="<?php echo e(asset('dashboard/libs/pdfmake/pdfmake.min.js')); ?>"></script>-->
<!--<script src="<?php echo e(asset('dashboard/libs/pdfmake/vfs_fonts.js')); ?>"></script>-->
<script src="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/js/buttons.print.min.js')); ?>"></script>
<!--<script src="<?php echo e(asset('dashboard/libs/datatables-net/extensions/buttons/js/buttons.colVis.min.js')); ?>"></script>-->
<?php echo $__env->yieldContent('js'); ?>
<script>


    $(".fab_images img").click(function () {
        $("#full-image").attr("src", $(this).attr("src"));
        $('#image-viewer').show();
    });

    $("#image-viewer .close").click(function () {
        $('#image-viewer').hide();
    });

</script>
<?php $__env->startSection('datatable'); ?>
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode = 'throw';
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            var table = $('#datatable');
            var datatable = table.DataTable({
                "initComplete": function () {
                    $('.dataTables_length select', '#datatable_wrapper').select2({
                        minimumResultsForSearch: Infinity
                    });
                    $('.dataTables_scrollBody', '#datatable_wrapper').jScrollPane();
                },
                <?php if(App::getLocale() == 'ar'): ?>
                "language": {
                    "sProcessing": "جارٍ التحميل...",
                    "sLengthMenu": "أظهر _MENU_ مدخلات",
                    "sZeroRecords": "لم يعثر على أية سجلات",
                    "sInfo": "إظهار _START_ إلى _END_ من أصل _TOTAL_ مدخل",
                    "sInfoEmpty": "يعرض 0 إلى 0 من أصل 0 سجل",
                    "sInfoFiltered": "(منتقاة من مجموع _MAX_ مُدخل)",
                    "sInfoPostFix": "",
                    "sSearch": "ابحث:",
                    "sUrl": "",
                    "oPaginate": {
                        "sFirst": "الأول",
                        "sPrevious": "السابق",
                        "sNext": "التالي",
                        "sLast": "الأخير"
                    }
                },
                <?php endif; ?>
                "order": [[0, "desc"]],
                "columnDefs": [{
                    "targets": 'no_sort',
                    "orderable": false
                }],

                "scrollY": false,
                "scrollCollapse": true,
                colReorder: false,
                processing: true,
                serverSide: true,

                dom: 'Blfrtip',
                buttons: [
                    // 'copyHtml5',
                    {
                        extend: 'print',

                        customize: function (win) {

                            $(win.document.body).find('td').removeClass('post_item')
                            ;
                        }
                    }
                    // 'excelHtml5'


                ],
                <?php echo $__env->yieldContent('data'); ?>
            });

            table.on('draw.dt', function () {
                $('.dataTables_scrollBody', '#datatable_wrapper').jScrollPane().data().jsp.destroy();
                $('.dataTables_scrollBody', '#datatable_wrapper').jScrollPane();
            });
            $('.dt-buttons.btn-group').wrap('<div class="col-sm-12 col-md-6" style="padding: 20px;display: inline-flex;float: right;"></div>');
            $('#datatable_filter').wrap('<div class="col-sm-12 col-md-6" style="padding: 0 20px;display: inline-flex"></div>');

        });
    </script>

<?php echo $__env->yieldSection(); ?>

<div class="mobile-overlay"></div>
</body>
</html>
</div>
<!-- / main menu-->


<!-- ////////////////////////////////////////////////////////////////////////////-->
<?php /**PATH D:\xampp\htdocs\projects\records\resources\views/cpanel/app.blade.php ENDPATH**/ ?>